<?php
/* --------------------------------------------------------------
 AuthenticationServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Auth;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Auth\HashStrategies\Md5HashStrategy;
use Gambio\Core\Auth\HashStrategies\PhpNativeHashStrategy;
use Gambio\Core\Auth\Repositories\JsonWebTokenRepository;
use Gambio\Core\Auth\Repositories\JsonWebTokenSecretProvider;
use Gambio\Core\Auth\Repositories\UserReader;
use Gambio\Core\Auth\Repositories\UserRepository;

/**
 * Class AuthenticationServiceProvider
 *
 * @package Gambio\Core\Auth
 */
class AuthenticationServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            UserAuthenticator::class,
            JsonWebTokenAuthenticator::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(UserReader::class)->addArgument(Connection::class);
        $this->application->add(UserRepository::class)->addArgument(UserReader::class);
        $this->application->add(PhpNativeHashStrategy::class);
        $this->application->add(Md5HashStrategy::class);
        
        $this->application->share(UserAuthenticator::class, Services\UserAuthenticator::class)
            ->addArgument(UserRepository::class)
            ->addArgument(PhpNativeHashStrategy::class)
            ->addArgument(Md5HashStrategy::class);
        
        $this->application->add(JsonWebTokenSecretProvider::class)->addArgument(Connection::class);
        $this->application->add(JsonWebTokenRepository::class)->addArgument(JsonWebTokenSecretProvider::class);
        
        $this->application->share(JsonWebTokenAuthenticator::class, Services\JsonWebTokenAuthenticator::class)
            ->addArgument(JsonWebTokenRepository::class);
    }
}